/**
 * some common functions
 * @author sunnyjiang
 * @version 1.1
 */

var utils = {};

/**
 * 对html字符进行实体转义
 */
utils.encodeHtml = function(text) {
    return text ? text.replace(/\&/ig, "&amp;").replace(/\</ig, "&lt;").replace(/\>/ig, "&gt;") : '';
};

/**
 * 从url中解析参数
 */
utils.parseUrl = function() {
	var url = location.href;
	var item = [];
	var result = {};
	var query = url.substr(url.indexOf('?') + 1);
	var tmp = query.split('&');

	for(var i = 0; i < tmp.length; i++){
		item = tmp[i].split('=');
		result[item[0]] = item[1];
	}
	return result;
};

/**
 * 从css的px值中得到数字
 */
utils.fromPx2Int = function(text) {
	if(!text)
		return 0;
	
	return parseInt(text.replace('px', ''));
};

/**
 * 得到随机的需要长度的数字
 */
utils.randomInt = function(length) {
	if(length <= 0)
		return;
	
	var number = 0;
	while(number < Math.pow(10, length - 1)) {
		number = Math.floor(Math.random() * Math.pow(10, length));
	}
	return number;
};

String.prototype.replaceAll = function(AFindText, ARepText){   
	return this.replace(new RegExp(AFindText, "gm"), ARepText);   
};